//
//  IFZoomView.m
//  PDFReader
//
//  Created by Dong Li on 12-5-2.
//  Copyright (c) 2013年 ITX. All rights reserved.
//

#import "IFZoomView.h"

@implementation IFZoomView

@synthesize zoomViewDelegate = _zoomViewDelegate;

- (id)initWithFrame:(CGRect)frame {
    if (self = [super initWithFrame:frame]) {
        [self setDelegate:self];
        [self setMinimumZoomScale:1.f];
        [self setMaximumZoomScale:8.f];
        [self setDecelerationRate:UIScrollViewDecelerationRateFast];
    }
    return self;
}

- (void)setContentInset:(UIEdgeInsets)contentInset {
    [super setContentInset:UIEdgeInsetsZero];
}

#pragma mark - Touch Event Actions

- (BOOL)touchesShouldBegin:(NSSet *)touches withEvent:(UIEvent *)event inContentView:(UIView *)view {
    return YES;
}

- (BOOL)touchesShouldCancelInContentView:(UIView *)view {
    return NO;
}

- (void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event {
	UITouch *touch = [touches anyObject];
    
	_touchBeganPoint = [touch locationInView:self];
    [NSObject cancelPreviousPerformRequestsWithTarget:self];
    
    if (_userInteracting) {
        ++ _tapCount;
    } else {
        _userInteracting = YES;
        _tapCount = 1;
        _touchMoved = NO;
        _beganTimestamp = [touch timestamp];
    }
}

- (void)movingTest:(UITouch *)touch {
    if (!_touchMoved) {
        CGPoint location = [touch locationInView:self];
        const CGFloat cx = location.x - _touchBeganPoint.x;
        const CGFloat cy = location.y - _touchBeganPoint.y;
        const CGFloat distance = sqrtf(cx * cx + cy * cy);
        if (distance > 20) {
            _touchMoved = YES;
        }
    }
}

- (void)touchesMoved:(NSSet *)touches withEvent:(UIEvent *)event {
    [self movingTest:[touches anyObject]];
}

- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event {
    UITouch *touch = [touches anyObject];
    
    [self movingTest:touch];
    
    if (_touchMoved) {
        _userInteracting = NO;
    } else {
        const NSTimeInterval currentTime = [touch timestamp];
        const NSTimeInterval deltaTime = currentTime - _beganTimestamp;
        if (_tapCount == 1) {
            if (deltaTime < 1.f) {
                [self performSelector:@selector(singleTapAction) withObject:nil afterDelay:0.3];
            } else {
                _userInteracting = NO;
            }
        } else if (_tapCount == 2) {
            if (deltaTime < 1.f) {
                if ([self zoomScale] < 1.5f) {
                    [self setZoomScale:2.f animated:YES];
                } else {
                    [self setZoomScale:1.f animated:YES];
                }
            }
            _userInteracting = NO;
        }
    }
}

- (void)singleTapAction {
    _userInteracting = NO;
    [_zoomViewDelegate toggleFullScreen:self];
}

- (void)stopDecelerating {
    if ([self isDecelerating]) {
        CGPoint offset = [self contentOffset];
        
        offset.x += 1.0;
        offset.y += 1.0;
        [self setContentOffset:offset animated:NO];
        offset.x -= 1.0;
        offset.y -= 1.0;
        [self setContentOffset:offset animated:NO];
    }
}

@end
